<?php

/**
 * @file
 * Bulk export of views_default objects generated by Bulk export module.
 */

/**
 * Implements hook_views_default_views().
 */
function mailjet_stats_views_default_views() {
  $views = array();
  if (module_exists('commerce')) {
    $view = new view();
    $view->name = 'mailjet_roi';
    $view->description = 'View the financial impact (total revenue and total number of sales) generated by each of your marketing campaigns';
    $view->tag = 'commerce_reports';
    $view->base_table = 'commerce_order';
    $view->human_name = 'Mailjet ROI Stats';
    $view->core = 7;
    $view->api_version = '3.0';
    $view->disabled = FALSE; /* Edit this to true to make a default view disabled initially */

    /* Display: Master */
    $handler = $view->new_display('default', 'Master', 'default');
    $handler->display->display_options['title'] = 'Sales report';
    $handler->display->display_options['css_class'] = 'commerce-reports';
    $handler->display->display_options['use_more_always'] = FALSE;
    $handler->display->display_options['group_by'] = TRUE;
    $handler->display->display_options['access']['type'] = 'perm';
    $handler->display->display_options['access']['perm'] = 'access commerce reports';
    $handler->display->display_options['cache']['type'] = 'none';
    $handler->display->display_options['query']['type'] = 'views_query';
    $handler->display->display_options['query']['options']['query_comment'] = FALSE;
    $handler->display->display_options['exposed_form']['type'] = 'basic';
    $handler->display->display_options['exposed_form']['options']['submit_button'] = 'Refresh report';
    $handler->display->display_options['pager']['type'] = 'none';
    $handler->display->display_options['style_plugin'] = 'table';
    $handler->display->display_options['style_options']['columns'] = array(
      'sales_data' => 'sales_data',
      'order_id' => 'order_id',
      'commerce_order_total' => 'commerce_order_total',
      'commerce_order_total_1' => 'commerce_order_total_1',
    );
    $handler->display->display_options['style_options']['default'] = 'sales_data';
    $handler->display->display_options['style_options']['info'] = array(
      'sales_data' => array(
        'sortable' => 1,
        'default_sort_order' => 'asc',
        'align' => '',
        'separator' => '',
        'empty_column' => 0,
      ),
      'order_id' => array(
        'sortable' => 0,
        'default_sort_order' => 'asc',
        'align' => '',
        'separator' => '',
        'empty_column' => 0,
      ),
      'commerce_order_total' => array(
        'sortable' => 0,
        'default_sort_order' => 'asc',
        'align' => '',
        'separator' => '',
        'empty_column' => 0,
      ),
      'commerce_order_total_1' => array(
        'sortable' => 0,
        'default_sort_order' => 'asc',
        'align' => '',
        'separator' => '',
        'empty_column' => 0,
      ),
    );
    /* Relationship: Campaign: Relation ship with orders */
    $handler->display->display_options['relationships']['order_id']['id'] = 'order_id';
    $handler->display->display_options['relationships']['order_id']['table'] = 'mailjet_campaign';
    $handler->display->display_options['relationships']['order_id']['field'] = 'order_id';
    /* Field: COUNT(Commerce Order: Order ID) */
    $handler->display->display_options['fields']['order_id']['id'] = 'order_id';
    $handler->display->display_options['fields']['order_id']['table'] = 'commerce_order';
    $handler->display->display_options['fields']['order_id']['field'] = 'order_id';
    $handler->display->display_options['fields']['order_id']['group_type'] = 'count';
    $handler->display->display_options['fields']['order_id']['label'] = 'Number of Orders';
    /* Field: SUM(Commerce Order: Order total) */
    $handler->display->display_options['fields']['commerce_order_total']['id'] = 'commerce_order_total';
    $handler->display->display_options['fields']['commerce_order_total']['table'] = 'field_data_commerce_order_total';
    $handler->display->display_options['fields']['commerce_order_total']['field'] = 'commerce_order_total';
    $handler->display->display_options['fields']['commerce_order_total']['group_type'] = 'sum';
    $handler->display->display_options['fields']['commerce_order_total']['label'] = 'Total Revenue';
    $handler->display->display_options['fields']['commerce_order_total']['click_sort_column'] = 'amount';
    $handler->display->display_options['fields']['commerce_order_total']['settings'] = array(
      'calculation' => FALSE,
    );
    $handler->display->display_options['fields']['commerce_order_total']['group_column'] = 'amount';
    $handler->display->display_options['fields']['commerce_order_total']['group_columns'] = array(
      'currency_code' => 'currency_code',
    );
    /* Field: AVG(Commerce Order: Order total) */
    $handler->display->display_options['fields']['commerce_order_total_1']['id'] = 'commerce_order_total_1';
    $handler->display->display_options['fields']['commerce_order_total_1']['table'] = 'field_data_commerce_order_total';
    $handler->display->display_options['fields']['commerce_order_total_1']['field'] = 'commerce_order_total';
    $handler->display->display_options['fields']['commerce_order_total_1']['group_type'] = 'avg';
    $handler->display->display_options['fields']['commerce_order_total_1']['label'] = 'Average Order';
    $handler->display->display_options['fields']['commerce_order_total_1']['click_sort_column'] = 'amount';
    $handler->display->display_options['fields']['commerce_order_total_1']['settings'] = array(
      'calculation' => FALSE,
    );
    $handler->display->display_options['fields']['commerce_order_total_1']['group_column'] = 'amount';
    $handler->display->display_options['fields']['commerce_order_total_1']['group_columns'] = array(
      'currency_code' => 'currency_code',
    );
    /* Filter criterion: Commerce Order: Order state */
    $handler->display->display_options['filters']['state']['id'] = 'state';
    $handler->display->display_options['filters']['state']['table'] = 'commerce_order';
    $handler->display->display_options['filters']['state']['field'] = 'state';
    $handler->display->display_options['filters']['state']['value'] = array(
      'pending' => 'pending',
      'completed' => 'completed',
    );
    $handler->display->display_options['filters']['state']['exposed'] = TRUE;
    $handler->display->display_options['filters']['state']['expose']['operator_id'] = 'state_op';
    $handler->display->display_options['filters']['state']['expose']['label'] = 'Order statuses';
    $handler->display->display_options['filters']['state']['expose']['operator'] = 'state_op';
    $handler->display->display_options['filters']['state']['expose']['identifier'] = 'state';
    $handler->display->display_options['filters']['state']['expose']['multiple'] = TRUE;

    /* Display: MailJet ROI */
    $handler = $view->new_display('page', 'Mailjet ROI', 'page');
    $handler->display->display_options['defaults']['title'] = FALSE;
    $handler->display->display_options['title'] = 'Mailjet ROI';
    $handler->display->display_options['defaults']['hide_admin_links'] = FALSE;
    $handler->display->display_options['defaults']['style_plugin'] = FALSE;
    $handler->display->display_options['style_plugin'] = 'table';
    $handler->display->display_options['style_options']['columns'] = array(
      'created' => 'created',
      'order_id' => 'order_id',
      'commerce_order_total' => 'commerce_order_total',
      'commerce_order_total_1' => 'commerce_order_total_1',
    );
    $handler->display->display_options['style_options']['default'] = '-1';
    $handler->display->display_options['style_options']['info'] = array(
      'created' => array(
        'sortable' => 0,
        'default_sort_order' => 'asc',
        'align' => '',
        'separator' => '',
        'empty_column' => 0,
      ),
      'order_id' => array(
        'sortable' => 1,
        'default_sort_order' => 'asc',
        'align' => '',
        'separator' => '',
        'empty_column' => 0,
      ),
      'commerce_order_total' => array(
        'sortable' => 1,
        'default_sort_order' => 'asc',
        'align' => '',
        'separator' => '',
        'empty_column' => 0,
      ),
      'commerce_order_total_1' => array(
        'sortable' => 1,
        'default_sort_order' => 'asc',
        'align' => '',
        'separator' => '',
        'empty_column' => 0,
      ),
    );
    $handler->display->display_options['defaults']['style_options'] = FALSE;
    $handler->display->display_options['defaults']['row_plugin'] = FALSE;
    $handler->display->display_options['defaults']['row_options'] = FALSE;
    $handler->display->display_options['defaults']['fields'] = FALSE;
    /* Field: Commerce Order: MailJet Campaign ID */
    $handler->display->display_options['fields']['mailjet_campaign_id']['id'] = 'mailjet_campaign_id';
    $handler->display->display_options['fields']['mailjet_campaign_id']['table'] = 'field_data_mailjet_campaign_id';
    $handler->display->display_options['fields']['mailjet_campaign_id']['field'] = 'mailjet_campaign_id';
    $handler->display->display_options['fields']['mailjet_campaign_id']['label'] = 'Campaign ID';
    $handler->display->display_options['fields']['mailjet_campaign_id']['element_type'] = '0';
    $handler->display->display_options['fields']['mailjet_campaign_id']['element_label_colon'] = FALSE;
    $handler->display->display_options['fields']['mailjet_campaign_id']['element_wrapper_type'] = '0';
    $handler->display->display_options['fields']['mailjet_campaign_id']['element_default_classes'] = FALSE;
    $handler->display->display_options['fields']['mailjet_campaign_id']['field_api_classes'] = TRUE;
    /* Field: Campaign: Campaign name */
    $handler->display->display_options['fields']['name']['id'] = 'name';
    $handler->display->display_options['fields']['name']['table'] = 'mailjet_campaign';
    $handler->display->display_options['fields']['name']['field'] = 'name';
    /* Field: COUNT(Commerce Order: Order ID) */
    $handler->display->display_options['fields']['order_id']['id'] = 'order_id';
    $handler->display->display_options['fields']['order_id']['table'] = 'commerce_order';
    $handler->display->display_options['fields']['order_id']['field'] = 'order_id';
    $handler->display->display_options['fields']['order_id']['group_type'] = 'count';
    $handler->display->display_options['fields']['order_id']['label'] = 'Number of Orders';
    $handler->display->display_options['fields']['order_id']['separator'] = '';
    /* Field: AVG(Commerce Order: Order total) */
    $handler->display->display_options['fields']['commerce_order_total_1']['id'] = 'commerce_order_total_1';
    $handler->display->display_options['fields']['commerce_order_total_1']['table'] = 'field_data_commerce_order_total';
    $handler->display->display_options['fields']['commerce_order_total_1']['field'] = 'commerce_order_total';
    $handler->display->display_options['fields']['commerce_order_total_1']['group_type'] = 'avg';
    $handler->display->display_options['fields']['commerce_order_total_1']['label'] = 'Average Order Value';
    $handler->display->display_options['fields']['commerce_order_total_1']['click_sort_column'] = 'amount';
    $handler->display->display_options['fields']['commerce_order_total_1']['settings'] = array(
      'calculation' => FALSE,
    );
    $handler->display->display_options['fields']['commerce_order_total_1']['group_column'] = 'amount';
    $handler->display->display_options['fields']['commerce_order_total_1']['group_columns'] = array(
      'currency_code' => 'currency_code',
    );
    /* Field: SUM(Commerce Order: Order total) */
    $handler->display->display_options['fields']['commerce_order_total']['id'] = 'commerce_order_total';
    $handler->display->display_options['fields']['commerce_order_total']['table'] = 'field_data_commerce_order_total';
    $handler->display->display_options['fields']['commerce_order_total']['field'] = 'commerce_order_total';
    $handler->display->display_options['fields']['commerce_order_total']['group_type'] = 'sum';
    $handler->display->display_options['fields']['commerce_order_total']['label'] = 'Total Revenue';
    $handler->display->display_options['fields']['commerce_order_total']['click_sort_column'] = 'amount';
    $handler->display->display_options['fields']['commerce_order_total']['settings'] = array(
      'calculation' => FALSE,
    );
    $handler->display->display_options['fields']['commerce_order_total']['group_column'] = 'amount';
    $handler->display->display_options['fields']['commerce_order_total']['group_columns'] = array(
      'currency_code' => 'currency_code',
    );
    /* Field: Campaign: Campaign created date */
    $handler->display->display_options['fields']['created']['id'] = 'created';
    $handler->display->display_options['fields']['created']['table'] = 'mailjet_campaign';
    $handler->display->display_options['fields']['created']['field'] = 'created';
    $handler->display->display_options['fields']['created']['label'] = 'Created date';
    $handler->display->display_options['fields']['created']['date_format'] = 'long';
    $handler->display->display_options['fields']['created']['second_date_format'] = 'long';
    $handler->display->display_options['fields']['created']['format_date_sql'] = 0;
    $handler->display->display_options['defaults']['sorts'] = FALSE;
    $handler->display->display_options['defaults']['filter_groups'] = FALSE;
    $handler->display->display_options['defaults']['filters'] = FALSE;
    /* Filter criterion: Commerce Order: Order state */
    $handler->display->display_options['filters']['state']['id'] = 'state';
    $handler->display->display_options['filters']['state']['table'] = 'commerce_order';
    $handler->display->display_options['filters']['state']['field'] = 'state';
    $handler->display->display_options['filters']['state']['value'] = array(
      'pending' => 'pending',
      'completed' => 'completed',
    );
    $handler->display->display_options['filters']['state']['exposed'] = TRUE;
    $handler->display->display_options['filters']['state']['expose']['operator_id'] = 'state_op';
    $handler->display->display_options['filters']['state']['expose']['label'] = 'Order statuses';
    $handler->display->display_options['filters']['state']['expose']['operator'] = 'state_op';
    $handler->display->display_options['filters']['state']['expose']['identifier'] = 'state';
    $handler->display->display_options['filters']['state']['expose']['multiple'] = TRUE;
    /* Filter criterion: Commerce Order: MailJet Campaign ID (mailjet_campaign_id) */
    $handler->display->display_options['filters']['mailjet_campaign_id_value']['id'] = 'mailjet_campaign_id_value';
    $handler->display->display_options['filters']['mailjet_campaign_id_value']['table'] = 'field_data_mailjet_campaign_id';
    $handler->display->display_options['filters']['mailjet_campaign_id_value']['field'] = 'mailjet_campaign_id_value';
    $handler->display->display_options['filters']['mailjet_campaign_id_value']['operator'] = 'not empty';
    $handler->display->display_options['path'] = 'admin/mailjet-stats/roi-stats-view';
  /*  $handler->display->display_options['menu']['type'] = 'normal';
    $handler->display->display_options['menu']['title'] = 'ROI Stats';
    $handler->display->display_options['menu']['description'] = 'Click here to view the financial impact (total revenue and total number of sales) generated by each of your marketing campaigns';
    $handler->display->display_options['menu']['weight'] = '6';
    $handler->display->display_options['menu']['name'] = 'management';
    $handler->display->display_options['menu']['context'] = 0;
    $handler->display->display_options['menu']['context_only_inline'] = 0;*/
    $handler->display->display_options['tab_options']['type'] = 'normal';
    $handler->display->display_options['tab_options']['title'] = 'Sales totals';
    $handler->display->display_options['tab_options']['description'] = 'View daily and monthly sales totals.';
    $handler->display->display_options['tab_options']['weight'] = '-10';
    $handler->display->display_options['tab_options']['name'] = 'management';
    $views['mailjet_roi'] = $view;
  }
  return $views;
}

